<?php
/* --------------------------------------------------------------
   TrackingCodeService.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Interfaces;

use Gambio\Admin\TrackingCode\Exceptions\TrackingCodeNotFoundException;

/**
 * Interface TrackingCodeService
 *
 * @package Gambio\Admin\TrackingCode\Interfaces
 */
interface TrackingCodeService
{
    /**
     * @param TrackingCodeSqlCriteria   $criteria
     * @param TrackingCodeSqlPagination $pagination
     *
     * @return TrackingCodes
     */
    public function getAllTrackingCodes(
        TrackingCodeSqlCriteria $criteria,
        TrackingCodeSqlPagination $pagination
    ): TrackingCodes;
    
    
    /**
     * @param TrackingCodeSqlCriteria $criteria
     *
     * @return int
     */
    public function getTotalCountOfTrackingCodes(TrackingCodeSqlCriteria $criteria): int;
    
    
    /**
     * @param TrackingCodeId $id
     *
     * @return TrackingCode
     *
     * @throws TrackingCodeNotFoundException
     */
    public function getTrackingCodeById(TrackingCodeId $id): TrackingCode;
    
    
    /**
     * @param TrackingCode $trackingCode
     *
     * @return TrackingCodeId
     */
    public function storeTrackingCode(TrackingCode $trackingCode): TrackingCodeId;
    
    
    /**
     * @param TrackingCodes $trackingCodes
     *
     * @return TrackingCodeIds
     */
    public function storeTrackingCodes(TrackingCodes $trackingCodes): TrackingCodeIds;
    
    
    /**
     * @param TrackingCodeId $id
     */
    public function deleteTrackingCode(TrackingCodeId $id): void;
    
    
    /**
     * @param TrackingCodeIds $ids
     */
    public function deleteTrackingCodes(TrackingCodeIds $ids): void;
}